/****** Object:  StoredProcedure [dbo].[P_GERA_RESSUPRIMENTO_FORNECEDOR_FILIAL]    Script Date: 07/11/2013 14:02:45 ******/
IF  EXISTS (SELECT * FROM sys.objects 
				WHERE 
					object_id = OBJECT_ID(N'[dbo].[P_GERA_RESSUPRIMENTO_FORNECEDOR_FILIAL]') 
					AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[P_GERA_RESSUPRIMENTO_FORNECEDOR_FILIAL]
GO
GO
 
--EXECUTE P_GERA_RESSUPRIMENTO_FORNECEDOR_FILIAL 1,0,1,30,1
--EXECUTE P_GERA_RESSUPRIMENTO_FORNECEDOR_FILIAL 1,0,0,0,1

CREATE PROCEDURE [dbo].[P_GERA_RESSUPRIMENTO_FORNECEDOR_FILIAL] 
													@CD_EMP          INT, 
                                                    @CD_FILIAL       INT = 0, 
                                                    @FLAGPERCACIMA   INT = 0,   
                                                    @PERCACIMA       MONEY = 0,
                                                    @CD_CTR_DEPO     INT   = 1  WITH ENCRYPTION  AS
 
SET NOCOUNT ON;
SET DEADLOCK_PRIORITY HIGH;
 
DECLARE @CD_FILIAL_DEPOS  INT;
DECLARE @AGORA DATETIME;
DECLARE @TIPOPRODUTOCOMPRA AS INT;
DECLARE @MEDIAF_MIN AS MONEY

SET @TIPOPRODUTOCOMPRA = ISNULL((SELECT VALOR FROM PRC_EMP_CONFIG WHERE PRC_EMP_CONFIG.CD_CHAVE = 'FLAG_CONTROLE_TIPO_PRODUTO_PEDIDO_ELETRONICO'),0)
SET @MEDIAF_MIN = ISNULL((SELECT VALOR FROM PRC_EMP_CONFIG WHERE PRC_EMP_CONFIG.CD_CHAVE = 'MEDIAF_MINIMA_GERACAO_DEMANDA_PEDIDO_ELETRONICO'),0)
SELECT @CD_FILIAL_DEPOS =(SELECT CD_FILIAL FROM PRC_FILIAL_DEPOSITO WHERE CD_CTR_DEPO =  @CD_CTR_DEPO );
SET @AGORA = CONVERT(CHAR(10),GETDATE(),120);

	Print 'Inicio geracao demanda Ped eletronico - Time ' +convert(varchar,getdate(),108);
	IF EXISTS ( SELECT * FROM SYS.OBJECTS
			WHERE NAME ='ELTR_RS_TIPOPRODUTO')
	BEGIN 
		DROP TABLE ELTR_RS_TIPOPRODUTO
	END 
	CREATE TABLE dbo.ELTR_RS_TIPOPRODUTO(TIPOPRODUTO INT)
 
	--Produto ressuprimento
	INSERT INTO ELTR_RS_TIPOPRODUTO
	SELECT   0
 
	--Produto sup-ressup
	IF @TIPOPRODUTOCOMPRA = 1
	BEGIN 
	   INSERT INTO ELTR_RS_TIPOPRODUTO
	   SELECT 2
	END
 
	IF EXISTS ( SELECT * FROM SYS.OBJECTS
			WHERE NAME ='ELTR_RS_PROD')
	BEGIN 
		DROP TABLE ELTR_RS_PROD
	END
	 
	CREATE TABLE dbo.ELTR_RS_PROD ( CD_FILIAL		INT,
									  CD_PROD		INT,
									  EMAX			MONEY,
									  QMIN			MONEY,
									  QTDE_MEDIAF	MONEY,
									  QT_EST		MONEY,
									  QTDE_RESSUP	MONEY,
									  VLR_PROD		MONEY,
									  EMAX_CAD		MONEY,
									  ESEG_CAD		MONEY,
									  QT_EST_CAD	MONEY,
									  MEDIAF		MONEY,
									  FLAG_RESSUPRIMENTO_CAIXA_FECHADA	INT,
									  QT_UNI_RESSUPRIMENTO				INT,
									  FLAG_RATEIO				INT,
									  QT_EST_CD_DISP			MONEY
									  PRIMARY KEY (CD_FILIAL,CD_PROD));


 	IF EXISTS ( SELECT * FROM SYS.OBJECTS
			WHERE NAME ='ELTR_RS_ARVMERC')
	BEGIN 
		DROP TABLE ELTR_RS_ARVMERC
	END
	 
	CREATE TABLE dbo.ELTR_RS_ARVMERC(    CD_EMP                INT,
										 CD_FILIAL             INT,
										 CD_PROD               INT,
										 ESEG                  MONEY,
										 EMAX                  MONEY,
										 QTDE_MEDIAP           MONEY,
										 QT_EST_PEND           MONEY,
										 QT_EST_MTZ            MONEY,
										 CD_GRP_PARAM          INT,
										 CD_SIGLA              INT,
										 CD_ARV_MERC_LINHA     INT,
										 CD_FABRIC             INT,
										 FLAG_RESSUPRIMENTO_CAIXA_FECHADA	INT,
										 QT_UNI_RESSUPRIMENTO				INT)
										  
	IF EXISTS ( SELECT * FROM SYS.OBJECTS
			WHERE NAME ='ELTR_RS_PROD_CONSOLIDADO')
	BEGIN 
		DROP TABLE ELTR_RS_PROD_CONSOLIDADO
	END
	
	CREATE TABLE dbo.ELTR_RS_PROD_CONSOLIDADO ( CD_PROD								INT,
												QT_UNI_RESSUPRIMENTO				INT,
												FLAG_RESSUPRIMENTO_CAIXA_FECHADA	INT, 
												QT_EST_FILIAIS_SOMA					MONEY,
												QT_MEDIAF_SOMA						MONEY,
												QT_RESSUP_SOMA						MONEY,
												QT_NECESSIDADE_FILIAIS				MONEY,
												QT_DEPOSITO_INICIO					MONEY,
												QT_DEPOSITO							MONEY,
												FLAG_RATEIO							INT,
												QT_EST_CD_DISP_SOMA				MONEY);
	
	DELETE FROM D
	FROM  
		   EST_PED_ELTR_DEMANDA D
		   INNER JOIN V_PRC_FILIAL_DEPOSITO F ON 
		   D.CD_EMP    =F.CD_EMP AND 
		   D.CD_FILIAL =F.CD_FILIAL  
	WHERE 
		   D.CD_EMP=@CD_EMP
		   AND F.CD_CTR_DEPO = @CD_CTR_DEPO
		   AND D.TP_PED=0; 

	Print 'Criados parametros auxiliares - Time ' +convert(varchar,getdate(),108);

	Print 'Carrega tabela ELTR_RS_ARVMERC - Time ' +convert(varchar,getdate(),108);
    INSERT INTO ELTR_RS_ARVMERC  (CD_EMP,CD_FILIAL,CD_PROD,ESEG,
									EMAX,QTDE_MEDIAP, QT_EST_PEND, QT_EST_MTZ,
									CD_GRP_PARAM,CD_SIGLA, CD_ARV_MERC_LINHA, CD_FABRIC,
									FLAG_RESSUPRIMENTO_CAIXA_FECHADA, QT_UNI_RESSUPRIMENTO	)
    SELECT 
        ARVMERC.CD_EMP, 
        ARVMERC.CD_FILIAL,
        ARVMERC.CD_PROD,
        CASE WHEN @FLAGPERCACIMA = 0 THEN
            ARVMERC.ESEG
        ELSE
            CASE WHEN @FLAGPERCACIMA = 1 THEN  --POR PERCENTUAL
                ARVMERC.ESEG * ((@PERCACIMA/100.0000) + 1)
            ELSE --DIA FIXO DE COMPRA
                @PERCACIMA
            END
        END,
        CASE WHEN @FLAGPERCACIMA = 0 THEN
            ARVMERC.EMAX
        ELSE
            CASE WHEN @FLAGPERCACIMA = 1 THEN  --POR PERCENTUAL
                ARVMERC.EMAX * ((@PERCACIMA/100.0000) + 1)
            ELSE --DIA FIXO DE COMPRA
                @PERCACIMA
            END
        END,              
        PEND.MEDIAF QTDE_MEDIAP,
        ISNULL(PEND.QT_EST_PEND,0) QT_EST_PEND,
        0,
        ARVMERC.CD_GRP_PARAM,
        ARVMERC.CD_SIGLA,
        ARVMERC.CD_ARV_MERC_LINHA,
        P.CD_FABRIC,
		ISNULL(P.FLAG_RESSUPRIMENTO_CAIXA_FECHADA,0) FLAG_RESSUPRIMENTO_CAIXA_FECHADA, 
		ISNULL(P.QT_UNI_RESSUPRIMENTO,1) QT_UNI_RESSUPRIMENTO
    FROM       
        V_EST_PROD_EST_ARV_MERCADOLOGICA ARVMERC 
        INNER JOIN V_EST_PROD_CPL_ESTOQUE_PEDIDO PEND ON 
        ARVMERC.CD_EMP        = PEND.CD_EMP AND
        ARVMERC.CD_FILIAL     = PEND.CD_FILIAL AND
        ARVMERC.CD_PROD       = PEND.CD_PROD   

        INNER JOIN V_PRC_FILIAL_DEPOSITO D ON 
        ARVMERC.CD_EMP       = D.CD_EMP AND
        ARVMERC.CD_FILIAL     = D.CD_FILIAL AND 
        D.CD_CTR_DEPO         = @CD_CTR_DEPO 

        INNER JOIN EST_PROD P ON 
        ARVMERC.CD_EMP = P.CD_EMP AND 
        ARVMERC.CD_PROD = P.CD_PROD   
	WHERE
        P.CD_EMP=@CD_EMP                
        AND P.COMPRA_POR_SUPRIMENTO IN (SELECT TIPOPRODUTO FROM ELTR_RS_TIPOPRODUTO p) 
        AND ISNULL( PEND.COMPRA_POR_SUPRIMENTO,0) IN (SELECT TIPOPRODUTO FROM ELTR_RS_TIPOPRODUTO p) 
        AND (PEND.MEDIAF > @MEDIAF_MIN  OR PEND.QTDE_FACEAMENTO > 0 OR  PEND.QTDE_FINANCIADO > 0)
        AND P.STS_PROD=0  
		--GERANDO DEMANDA PARA UMA UNICA FILIAL ELETRONICAMENTE
		AND CASE WHEN @CD_FILIAL > 0 THEN 
			ARVMERC.CD_FILIAL ELSE  @CD_FILIAL END = @CD_FILIAL
        AND PEND.STS_PROD_FILIAL = 0 ; 

		 
Print 'Carrega parametros especiais - Time ' +convert(varchar,getdate(),108);
--COMPRA POR DIA DE COBERTURA FIXO SOMENTE PARA PRODUTO POR COMPRA POR OL 
IF @FLAGPERCACIMA = 2 
BEGIN
    --SOMENTE PRODUTO QUE A COMPRA 
    --EFETUADA POR OL
    DELETE  R
    FROM   ELTR_RS_ARVMERC R
    WHERE
        NOT EXISTS(SELECT  
						F.CD_EMP
					FROM
						EST_PROD_FORN F
					WHERE
						R.CD_EMP = F.CD_EMP AND
						R.CD_PROD = F.CD_PROD AND
						F.COMPRA_OL =1)
END

IF @FLAGPERCACIMA = 0
BEGIN
	--ANALIZANDO SE O PARAMETRO DE MEDIA F POSSUI ALGUM PARAMETRO ESPECIAL
	UPDATE 
		P
	SET 
		EMAX =     ROUND(P.EMAX + ((P.EMAX *  PESP.EMAX)/100.0000),0),
		ESEG =     ROUND(P.ESEG + ((P.ESEG *  PESP.ESEG)/100.0000),0)
	FROM         

		EST_ARV_MD_F_GRP_PARAM_ESPECIAIS PESP 
		INNER JOIN ELTR_RS_ARVMERC P ON
		PESP.CD_EMP           = P.CD_EMP AND
		PESP.CD_GRP_PARAM     = P.CD_GRP_PARAM
	WHERE
		(PESP.FDIAS_ULT_ATU IS NULL
		OR PESP.FDIAS_ULT_ATU <= DATEADD(DAY,- PESP.FDIAS, @AGORA))
		AND (DATEDIFF (DAY, PESP.DT_INICIAL , @AGORA) % PESP.FDIAS) = 0
		AND PESP.DT_INICIAL <=@AGORA; 

	--GERANDO AUMENTO DE PERCENTUAL DO EMAX E ESEG POR DATA
	UPDATE 
		P
	SET 
		EMAX                     =     ROUND(P.EMAX + ((P.EMAX *  AUMENT.PERC_AUMENTO)/100.0000),0),
		ESEG                     =     ROUND(P.ESEG + ((P.ESEG *  AUMENT.PERC_AUMENTO)/100.0000),0)
	FROM    
		EST_ARV_GRP_RESSUPRIMENTO_PERC_AUMENTO AUMENT     
		INNER JOIN ELTR_RS_ARVMERC P ON
		AUMENT.CD_EMP = P.CD_EMP AND
		AUMENT.CD_SIGLA = P.CD_SIGLA
	WHERE
		AUMENT.DT_RESSUP = @AGORA;

	--ANALIZANDO SE O PARAMETRO DE MEDIA F POSSUI ALGUM PARAMETRO ESPECIAL POR DIA DA SEMANA 
	UPDATE  
		P 
	SET  
		EMAX                     =     PESP.EMAX,
		ESEG                     =     PESP.ESEG
	FROM         
		EST_ARV_MD_F_GRP_PARAM_ESPECIAIS_DIA_SEMANA PESP       
		INNER JOIN ELTR_RS_ARVMERC P ON
		PESP.CD_EMP = P.CD_EMP AND
		PESP.CD_GRP_PARAM = P.CD_GRP_PARAM
	WHERE
		PESP.DIA_SEMANA = DATEPART(WEEKDAY,@AGORA)
		AND PESP.FLAG_APLICACAO IN (0,2);
       
END;
 
	Print 'Carga dos produtos para demanda do eletronico - Time ' +convert(varchar,getdate(),108);
	WITH BASE AS ( SELECT     
						mdf.CD_FILIAL, 
						mdf.CD_PROD, 
						dbo.UFD_EST_AJUSTA_EMAX(MDF.QTDE_FACEAMENTO, 
												MDF.VALID_QTDE_FACEAMENTO, 
												MDF.QTDE_FINANCIADO, 
												MDF.QTDE_LIMITADOR, 
												CASE WHEN MDF.QTDE_MEDIAF > 0 THEN 
														ROUND(MDF.QTDE_MEDIAF / 30.0000 * ARVMERC.EMAX, 0) 
													ELSE 
														ROUND(ARVMERC.QTDE_MEDIAP / 30.0000 * ARVMERC.EMAX, 0) END) AS EMAX,
                    
						dbo.UFD_EST_AJUSTA_ESEG(CASE WHEN ISNULL(MDF.PERC_ESEG_FACEAMENTO,0)=0 THEN
													MDF.QTDE_FACEAMENTO 
												ELSE
													ROUND(MDF.QTDE_FACEAMENTO  * (ISNULL(MDF.PERC_ESEG_FACEAMENTO,0)/100.00),0)
												END, 
												MDF.VALID_QTDE_FACEAMENTO, 
												MDF.QTDE_FINANCIADO, 
												CASE WHEN MDF.QTDE_MEDIAF > 0 THEN 
													ROUND(MDF.QTDE_MEDIAF / 30.0000 * ARVMERC.ESEG, 0) 
												ELSE 
													ROUND(ARVMERC.QTDE_MEDIAP / 30.0000 * ARVMERC.ESEG, 0) END) AS ESEG,
					
						CASE WHEN (arvmerc.QT_EST_PEND + ARVMERC.QT_EST_MTZ) < 0 THEN 
								0
							ELSE 
								arvmerc.QT_EST_PEND + ARVMERC.QT_EST_MTZ  
							END AS QT_EST,
						   
						CASE WHEN mdf.QTDE_MEDIAF > 0 THEN 
							mdf.QTDE_MEDIAF 
						ELSE 
							ARVMERC.QTDE_MEDIAP  
						END QTDE_MEDIAF,
						(SELECT dbo.UFD_BUSCA_PRECO_PRODUTO(MDF.CD_EMP,MDF.CD_FILIAL,MDF.CD_PROD,2,0,0)) AS VLR_PROD,
						ARVMERC.EMAX AS EMAX_CAD,
						ARVMERC.ESEG AS ESEG_CAD,
						ARVMERC.FLAG_RESSUPRIMENTO_CAIXA_FECHADA, 
						ARVMERC.QT_UNI_RESSUPRIMENTO
					FROM         
						EST_PROD_CPL_MEDIAF MDF 
						INNER JOIN ELTR_RS_ARVMERC ARVMERC ON 
						MDF.CD_EMP        = ARVMERC.CD_EMP AND 
						MDF.CD_FILIAL     = ARVMERC.CD_FILIAL AND
						MDF.CD_PROD       = ARVMERC.CD_PROD)  
 
	INSERT INTO ELTR_RS_PROD (CD_FILIAL,CD_PROD,EMAX,QMIN,
									  QTDE_MEDIAF,	QT_EST	,QTDE_RESSUP, VLR_PROD,
									  EMAX_CAD,ESEG_CAD,QT_EST_CAD,
									  MEDIAF,FLAG_RESSUPRIMENTO_CAIXA_FECHADA,
									  QT_UNI_RESSUPRIMENTO,FLAG_RATEIO, QT_EST_CD_DISP)
	SELECT     
		B.CD_FILIAL, 
		B.CD_PROD, 
		B.EMAX, 
		B.ESEG AS QMIN, 
		B.QTDE_MEDIAF,
		B.QT_EST, 
		CASE WHEN B.QT_EST <= 0 THEN
				ROUND(B.EMAX, 0)
		ELSE
				ROUND(B.EMAX - QT_EST, 0)
		END AS QTDE_RESSUP,
		B.VLR_PROD,
		B.EMAX_CAD,
		B.ESEG_CAD,
		B.QT_EST,
		B.QTDE_MEDIAF,
		B.FLAG_RESSUPRIMENTO_CAIXA_FECHADA, 
		B.QT_UNI_RESSUPRIMENTO,
		0 FLAG_RATEIO,
		CASE WHEN ISNULL(D.CD_EMP,0)=0 THEN
				0 ELSE CASE WHEN B.QT_EST <= 0 THEN
								ROUND(B.EMAX, 0)
						ELSE
								ROUND(B.EMAX - QT_EST, 0)
						END END QT_EST_CD_DISP
		
	FROM         
		BASE B
		LEFT JOIN  (SELECT	CD_EMP,
							CD_PROD,
							SUM((QT_EST + QT_EST_EM_TERC) - QT_PEND_SAI) AS QT_DEPOSITO_INICIO
						FROM
							V_EST_PROD_CPL_ESTOQUE_PEDIDO
						WHERE	
							CD_EMP=@CD_EMP 
							AND CD_FILIAL=@CD_FILIAL_DEPOS 
						GROUP BY
							CD_EMP,CD_PROD
						HAVING SUM((QT_EST + QT_EST_EM_TERC) - QT_PEND_SAI) > 0 ) D ON 
		B.CD_PROD = D.CD_PROD
	WHERE             
		ESEG >= QT_EST; --QTDEMIN MAIOR QUE A QUANTIDADE EM ESTOQUE  

/**********************************************************************************************************************/
--Abate o saldo de pedidos eletronicos em aberto
/**********************************************************************************************************************/

UPDATE R
SET
	QTDE_RESSUP = r.QTDE_RESSUP- s.QT_SLD
FROM
	ELTR_RS_PROD R
		INNER JOIN 
		(SELECT 
			E.CD_EMP,	
			E.CD_FIL_ENTR,	
			E.CD_PROD,	 
			E.QT_IT - ISNULL(P.QT_PED,0) QT_SLD 
		FROM 
			(SELECT 
				E.CD_EMP,
				E.CD_FIL_ENTR,
				I.CD_PROD,
				SUM(I.QT_IT_UN) QT_IT
			FROM         
				EST_PED_ELTR  E
				INNER JOIN EST_PED_ELTR_IT I ON 
				E.CD_EMP	 = I.CD_EMP AND 
				E.CD_PED_SOL = I.CD_PED_SOL 
			WHERE
				E.CD_EMP=1
				AND NOT  E.STS_PED IN (3,4)		
				AND E.FLAG_FECHAR = 0
				AND E.TP_REQ =0--IN(0,2)
			GROUP BY 
				E.CD_EMP,
				E.CD_FIL_ENTR,
				I.CD_PROD) E
			LEFT JOIN (SELECT 
							EP.CD_EMP, 
							EP.CD_FIL_ENTR,  
							PD.CD_PROD,
							SUM( PD.QT_IT * PD.QT_EMB ) QT_PED
						FROM
							EST_PED_ELTR_FORN_PED_CP EP 
							INNER JOIN DBO.EST_PED_CP_IT PD ON 
							EP.CD_EMP		= PD.CD_EMP AND 
							EP.CD_FIL_ENTR	= PD.CD_FILIAL AND 
							EP.CD_PED		= PD.CD_PED 
	
							INNER JOIN EST_PED_CP_PENDENCIA PE ON
							PD.CD_EMP	 = PE.CD_EMP AND
							PD.CD_FILIAL = PE.CD_FILIAL AND
							PD.CD_PED	 = PE.CD_PED
						GROUP BY 
							EP.CD_EMP, 
							EP.CD_FIL_ENTR,
							PD.CD_PROD) P ON 
			E.CD_EMP		= P.CD_EMP AND 
			E.CD_FIL_ENTR	= P.CD_FIL_ENTR AND
			E.CD_PROD		= P.CD_PROD

		where
			E.CD_EMP			=@CD_EMP 
			AND E.QT_IT - ISNULL(P.QT_PED,0) > 0)	S ON
	R.CD_FILIAL= S.CD_FIL_ENTR AND
	R.CD_PROD = S.CD_PROD;

	DELETE FROM ELTR_RS_PROD WHERE QTDE_RESSUP<1; 

/**********************************************************************************************************************/
-- Gerando o estoque da matriz... 
/**********************************************************************************************************************/
	
	Print 'Geracao do picking do estoque do CD - Time ' +convert(varchar,getdate(),108);
  
	WITH FILIAIS AS (SELECT	
						CD_PROD,
						QT_UNI_RESSUPRIMENTO,
						FLAG_RESSUPRIMENTO_CAIXA_FECHADA,
						QT_EST_FILIAIS_SOMA		= SUM(r.QT_EST),
						QT_MEDIAF_SOMA			= SUM(r.QTDE_MEDIAF),
						QT_RESSUP_SOMA			= SUM(ROUND(r.QTDE_RESSUP, 0)),
						QT_NECESSIDADE_FILIAIS	= SUM(case when r.FLAG_RESSUPRIMENTO_CAIXA_FECHADA=1 then
																ROUND((r.QTDE_RESSUP/r.QT_UNI_RESSUPRIMENTO),0)*r.QT_UNI_RESSUPRIMENTO
														else r.QTDE_RESSUP end) 
					FROM 
						ELTR_RS_PROD r
						LEFT JOIN EST_RESSUP_NAO_CONSIDERA_EST_CD_PRC_FILIAL F ON  
						R.CD_FILIAL = F.CD_FILIAL AND 
						F.FLAG_HABILITADO =1
					WHERE
						F.CD_FILIAL IS NULL
					GROUP BY 
						r.CD_PROD, 
						r.QT_UNI_RESSUPRIMENTO,
						r.FLAG_RESSUPRIMENTO_CAIXA_FECHADA),
		DEPOSITO AS (SELECT
							CD_PROD,
							SUM((QT_EST + QT_EST_EM_TERC) - QT_PEND_SAI) AS QT_DEPOSITO_INICIO
						FROM
							V_EST_PROD_CPL_ESTOQUE_PEDIDO
						WHERE	
							CD_EMP=@CD_EMP 
							AND CD_FILIAL=@CD_FILIAL_DEPOS 
						GROUP BY
							CD_PROD
						HAVING SUM((QT_EST + QT_EST_EM_TERC) - QT_PEND_SAI) > 0 )
	  
	INSERT INTO ELTR_RS_PROD_CONSOLIDADO(CD_PROD, QT_UNI_RESSUPRIMENTO,FLAG_RESSUPRIMENTO_CAIXA_FECHADA, 
										QT_EST_FILIAIS_SOMA, QT_MEDIAF_SOMA, QT_RESSUP_SOMA, QT_NECESSIDADE_FILIAIS, 
										QT_DEPOSITO_INICIO, QT_DEPOSITO, FLAG_RATEIO)
	SELECT	
		f.CD_PROD, 
		f.QT_UNI_RESSUPRIMENTO, 
		f.FLAG_RESSUPRIMENTO_CAIXA_FECHADA, 
		f.QT_EST_FILIAIS_SOMA, 
		f.QT_MEDIAF_SOMA, 
		f.QT_RESSUP_SOMA, 
		f.QT_NECESSIDADE_FILIAIS, 		
		CASE WHEN FLAG_RESSUPRIMENTO_CAIXA_FECHADA = 1 THEN 
			ROUND((d.QT_DEPOSITO_INICIO/f.QT_UNI_RESSUPRIMENTO),0)* f.QT_UNI_RESSUPRIMENTO  
		ELSE d.QT_DEPOSITO_INICIO END QT_DEPOSITO_INICIO,  
		QT_DEPOSITO = (CASE WHEN FLAG_RESSUPRIMENTO_CAIXA_FECHADA = 1 THEN 
							ROUND((d.QT_DEPOSITO_INICIO/f.QT_UNI_RESSUPRIMENTO),0)* f.QT_UNI_RESSUPRIMENTO  
						ELSE d.QT_DEPOSITO_INICIO END),
		0 FLAG_RATEIO
	FROM 
		FILIAIS f 
		INNER JOIN DEPOSITO d ON 
		d.CD_PROD=f.CD_PROD
	where
		f.QT_RESSUP_SOMA > (CASE WHEN FLAG_RESSUPRIMENTO_CAIXA_FECHADA = 1 THEN 
							ROUND((d.QT_DEPOSITO_INICIO/f.QT_UNI_RESSUPRIMENTO),0)* f.QT_UNI_RESSUPRIMENTO  
						ELSE d.QT_DEPOSITO_INICIO END) ;
		 
	DELETE FROM ELTR_RS_PROD_CONSOLIDADO WHERE QT_DEPOSITO < 1; 
	 
	UPDATE E
	SET	--Necessidade (-) o que tenho no deposito
		QT_EST_CD_DISP = CASE WHEN e.FLAG_RESSUPRIMENTO_CAIXA_FECHADA = 1 THEN 
								ROUND((ROUND((E.QTDE_RESSUP/C.QT_RESSUP_SOMA) * QT_DEPOSITO,0)/e.QT_UNI_RESSUPRIMENTO),0)* e.QT_UNI_RESSUPRIMENTO  
							ELSE ROUND((E.QTDE_RESSUP/C.QT_RESSUP_SOMA) * QT_DEPOSITO,0) END,
		E.FLAG_RATEIO=1
	FROM 
		ELTR_RS_PROD_CONSOLIDADO  C
		INNER JOIN ELTR_RS_PROD E ON 
		C.CD_PROD = E.CD_PROD
	WHERE 
		QTDE_RESSUP > 0; 
	
	--Ajusta a soma
	UPDATE s SET  
		QT_RESSUP_SOMA=QTDE_RESSUP,
		QT_DEPOSITO=QT_DEPOSITO_INICIO - QT_EST_CD_DISP,
		QT_EST_CD_DISP_SOMA=QT_EST_CD_DISP,
		FLAG_RATEIO=1
	FROM 
		ELTR_RS_PROD_CONSOLIDADO S
		INNER JOIN (SELECT CD_PROD, 
							SUM(QTDE_RESSUP) QTDE_RESSUP , 
							SUM(QT_EST_CD_DISP) QT_EST_CD_DISP
						FROM 
							ELTR_RS_PROD GROUP BY CD_PROD) E ON 
		S.CD_PROD = E.CD_PROD ;
		     
	Print 'Inicio do Rateio das quantidades do CD - Time ' +convert(varchar,getdate(),108);
	--Inicio do Rateio das quantidades do CD
	WHILE EXISTS   (SELECT * FROM ELTR_RS_PROD_CONSOLIDADO s
						WHERE QT_EST_CD_DISP_SOMA <> QT_DEPOSITO_INICIO)
	begin
	
		WITH BASE AS (SELECT 
							CD_PROD, 
							FATOR_AJUSTE=CASE WHEN FLAG_RESSUPRIMENTO_CAIXA_FECHADA =1 THEN
											QT_UNI_RESSUPRIMENTO * (case when QT_DEPOSITO_INICIO < QT_EST_CD_DISP_SOMA then -1 else 1 end)
										ELSE SIGN(QT_DEPOSITO_INICIO - QT_EST_CD_DISP_SOMA) END
							FROM 
								ELTR_RS_PROD_CONSOLIDADO 
							WHERE QT_EST_CD_DISP_SOMA <> QT_DEPOSITO_INICIO AND FLAG_RATEIO=1)
		UPDATE p 
		SET  
			QT_EST_CD_DISP =  CASE WHEN  QT_EST_CD_DISP + b.FATOR_AJUSTE  > QTDE_RESSUP THEN
									CASE WHEN FLAG_RESSUPRIMENTO_CAIXA_FECHADA =1 THEN
										CEILING( QTDE_RESSUP/QT_UNI_RESSUPRIMENTO ) *  QT_UNI_RESSUPRIMENTO 
									else	QTDE_RESSUP  end 
								ELSE QT_EST_CD_DISP + b.FATOR_AJUSTE  END,

			FLAG_RATEIO =  CASE WHEN  QT_EST_CD_DISP + b.FATOR_AJUSTE  > QTDE_RESSUP THEN
										0  ELSE 1 END    
		FROM 
			ELTR_RS_PROD p 
			JOIN BASE b ON 
			p.CD_PROD=b.CD_PROD
		WHERE  P.FLAG_RATEIO = 1 AND p.CD_FILIAL = (SELECT	 TOP 1 CD_FILIAL
								FROM 
									ELTR_RS_PROD
								WHERE 
									CD_PROD=b.CD_PROD 
									AND FLAG_RATEIO = 1
								ORDER BY 
									b.FATOR_AJUSTE * (QT_EST_CD_DISP + QT_EST + b.FATOR_AJUSTE) * 30 / CASE WHEN  QTDE_MEDIAF = 0 THEN 
																											.001 ELSE QTDE_MEDIAF END, 
									b.FATOR_AJUSTE * (QT_EST_CD_DISP + QT_EST + b.FATOR_AJUSTE) );
		--Ajusta a soma
		UPDATE s SET   
			QT_EST_CD_DISP_SOMA=QT_EST_CD_DISP 
		FROM 
			ELTR_RS_PROD_CONSOLIDADO S
			INNER JOIN (SELECT CD_PROD,   
								SUM(QT_EST_CD_DISP) QT_EST_CD_DISP
							FROM 
								ELTR_RS_PROD GROUP BY CD_PROD) E ON 
			S.CD_PROD = E.CD_PROD and
			QT_EST_CD_DISP_SOMA<>QT_EST_CD_DISP ;
	end 
	
	--Abate as quantidades de estoque que existem no CD
	UPDATE R
		 SET QTDE_RESSUP = QTDE_RESSUP -QT_EST_CD_DISP 
	FROM 
		ELTR_RS_PROD R; 


/**********************************************************************************************************************/
/**********************************************************************************************************************/

		Print 'Registro da demanda do pedido eletronico - Time ' +convert(varchar,getdate(),108);

       --ADICIONANDO OS ITENS DO RESSUPRIMENTO
       INSERT INTO EST_PED_ELTR_DEMANDA (CD_EMP, CD_FILIAL, CD_PROD,QTDE_PROD,
										  VLR_PROD,EMAX, ESEG,QT_EST,
										  MEDIAF,TP_PED,FLAG_PERC_ACIMA,PERC_ACIMA)

       SELECT     
              @CD_EMP,
              CD_FILIAL,
              CD_PROD,
              P.QTDE_RESSUP,
              VLR_PROD,
              EMAX_CAD,
              ESEG_CAD,
              QT_EST_CAD,
              MEDIAF,
              0 TP_PED,
              @FLAGPERCACIMA,
              @PERCACIMA
       FROM         
              ELTR_RS_PROD P
       WHERE     
              P.QTDE_RESSUP > 0;

--DROP TABLE ELTR_RS_PROD;
--DROP TABLE ELTR_RS_ARVMERC;
--DROP TABLE ELTR_RS_TIPOPRODUTO
--DROP TABLE ELTR_RS_PROD_CONSOLIDADO; 
 


GO


